package it.unicam.pizzeria4.view;

import java.util.Scanner;

public class InteractionManager {

	private ICameriere cameriere;
	private IAddettoSala addettoSala;
	private IGestore gestore;
	
	public InteractionManager() {
		cameriere = ICameriere.createICameriere();
		addettoSala = new IAddettoSala();
		gestore = IGestore.getInstance();
	}

	public void startPizzeria(Scanner reader) {
		String richiesta;
		while (true) {
			System.out.println("[INFO] Benvenuti nel sistema di gestione della Pizzeria");
			System.out.println("[INFO] Scegli cosa vuoi fare:");
			System.out.println("[INFO] Scegli 0 per assegnare un tavolo");
			System.out.println("[INFO] Scegli 1 per compilare la comanda");
			System.out.println("[INFO] Scegli 2 per ordine d'asporto");
			System.out.println("[INFO] Scegli 3 per aggiornare menu");
			System.out.println("[INFO] Scegli 4 per liberare il tavolo");
			System.out.println("[INFO] Scegli ... per ....");
			System.out.println("[INFO] Scegli 9 per uscire");
			richiesta = reader.nextLine();
			if (richiesta.equals("9"))
				break;
			if (richiesta.equals("0")) {
				addettoSala.assegnaTavolo(reader);
				continue;
			}
			if (richiesta.equals("1")) {
				cameriere.compilazioneComanda(reader);
				continue;
			} 
			if (richiesta.equals("3")) {
				gestore.aggiornaMenu(reader);
				continue;
			}
			if (richiesta.equals("4")) {
				addettoSala.liberaTavolo(reader);
				continue;
			} 
			else {
				continue;
			}
			
		}
		reader.close();
	}

}
